<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

use Dealerdirect\Agreements\Enums\Locale;

/**
 * @codeCoverageIgnore
 */
final class PurchaseAgreement implements DataObject
{
    public function __construct(
        public readonly Locale $locale,
        public readonly string $vehicleType,
        public readonly int $lotId,
        public readonly int $deliverId,
        public readonly int $siteReference,
        public readonly int $callGroupId,
        public readonly Contact $company,
        public readonly Contact $consumer,
        public readonly Vehicle $vehicle,
        public readonly Agent $salesAgent,
        public readonly bool $pickUp,
        public readonly \DateTime $soldDate,
        public readonly int $salesPrice,
        public readonly int $salesFee,
    ) {
    }
}
