<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class DeliveryNotFoundException extends \Exception
{
    /**
     * @param array<string,int|string> $params
     */
    public function __construct(
        public readonly string $query,
        array $params,
        string $calledClass
    ) {
        parent::__construct(
            "Delivery not found for params: [{$this->getParams($params)}] in '{$calledClass}'"
        );
    }

    /**
     * @param array<string,int|string> $params
     */
    private function getParams(array $params): string
    {
        return implode(', ', array_map(
            fn ($param) => sprintf('%s: %s', $param, $params[$param]),
            array_keys($params)
        ));
    }
}
