<?php

require_once dirname(__DIR__) . '/vendor/autoload.php';

use Doctrine\DBAL\DriverManager;
use Dealerdirect\Agreements\Utils;
use Dealerdirect\Agreements\Models\CarBeModel;
use Dealerdirect\Agreements\Models\CarNlModel;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Agreements\Models\MotorbikeModel;
use Dealerdirect\Agreements\Agreements\SalesAgreement;

$vehicleType = $_GET['vehicle_type'] ?? VehicleType::CAR;
VehicleType::assertExists($vehicleType);
$country = $_GET['country'] ?? 'nl';
$project = "{$vehicleType}_{$country}";
$deliverId = (int) ($_GET['deliver_id'] ?? 99141);
$dbName = Utils::isMotor($vehicleType) || Utils::isBicycle($vehicleType) ? 'dealer01_ddmoto' : 'dealer01_ddmain';

$dbal = DriverManager::getConnection(
    [
        'dbname' => $dbName,
        'user' => 'vagrant',
        'password' => 'vagrant',
        'host' => 'aio.test',
        'driver' => 'pdo_mysql',
    ],
    new \Doctrine\DBAL\Configuration()
);

switch ($project) {
    case 'car_nl':
        $model = new CarNlModel($dbal, $deliverId);
        break;
    case 'car_be':
        $model = new CarBeModel($dbal, $deliverId);
        break;
    case 'motorbike_nl':
    case 'motorbike_be':
    case 'motorbike_de':
    case 'bicycle_nl':
        $model = new MotorbikeModel($dbal, $deliverId);
        break;
    default:
        throw new Exception("Error, project '$project' is not defined!");
}

$agreement = new SalesAgreement(
    $model,
    'https://email-service.aio.test/api/v1',
    'file:///tmp/verkoopovereenkomsten/'
);

if ($agreement->create() === false) {
    $model->log('Could not create Sales Agreement');
    echo 'Could not create Sales Agreement';
    exit;
}
if ($agreement->send() === false) {
    $model->log('Could not send Sales Agreement');
    echo 'Could not send Sales Agreement';
    exit;
}
$model->log('Sales Agreement is created and send');
echo 'Sales Agreement is created and send';
