<?php

include_once dirname(__DIR__) . '/vendor/autoload.php';

use Dealerdirect\Agreements\Agreements\PurchaseAgreement;
use Dealerdirect\Agreements\Agreements\SalesAgreement;
use Dealerdirect\Agreements\Models\CarBeModel;
use Dealerdirect\Agreements\Models\CarNlModel;
use Dealerdirect\Agreements\Models\MotorbikeModel;
use Doctrine\DBAL\Configuration;
use Doctrine\DBAL\DriverManager;

$emailApiUrl = 'https://email-service.email-service.test/api/v1';
$location = 'file:///tmp/verkoopovereenkomsten/';
$impersonateKey = 'R72SaMOwBou595zLuW1HtPHkYZd6og1T';
$dealerdirect = 'https://dealerdirect.eu.aio.test';
$dbal = DriverManager::getConnection(
    [
        'dbname' => 'dealer01_ddmain',
        'user' => 'vagrant',
        'password' => 'vagrant',
        'host' => 'aio.test',
        'driver' => 'pdo_mysql',
    ],
    new Configuration()
);

function webservice_request($wr_method, $wr_params = [])
{
    $client = new nusoap_client('http://dealers-soap-api.aio.test/service.php');
    $client->timeout = 300;
    $client->response_timeout = 300;

    return $client->call($wr_method, $wr_params);
}

// Make sure all requests are processed
$dbal->update('dealer01_ddmain.verkopen_request_sent', ['processed' => 1], ['processed' => 0]);
$dbal->update('dealer01_ddmoto.verkopen_request_moto_sent', ['processed' => 1], ['processed' => 0]);

$query = <<<SQL
SELECT * %s
FROM %s
WHERE site = :site
ORDER BY id DESC
LIMIT 4
SQL;

$selects = [
    'car' => [1, 2],
    'motorbike' => [1, 2, 10, 20]
];

foreach ($selects as $vehicleType => $siteIds) {
    $data = [];
    $table = 'dealer01_ddmain.verkopen_request_sent';
    $oldMethod = 'BO_verkoop_Sent';
    $subSelect = '';
    if ($vehicleType === 'motorbike') {
        $table = 'dealer01_ddmoto.verkopen_request_moto_sent';
        $oldMethod = 'BO_verkoop_Moto_Sent';
        $subSelect = <<<SQL
,
(
    SELECT id
    FROM dealer01_ddmoto.BO_Verkopen_NL
    WHERE kavelref = verkopen_request_moto_sent.kavel
    ORDER BY id DESC
    LIMIT 1
) AS deliver_id
SQL;
    }

    foreach ($siteIds as $site) {
        $data = array_merge(
            $data,
            $dbal->fetchAll(sprintf($query, $subSelect, $table), ['site' => $site])
        );
    }

    foreach ($data as $delivery) {
        // Update the old way to resend the agreement.
        $dbal->update($table, ['processed' => 0], ['id' => $delivery['id']]);
        // Call dealers-soap-service OLD way
        $old = webservice_request($oldMethod);

        // Get the correct Model
        if ($vehicleType === 'car') {
            switch ($delivery['site']) {
                case 1:
                    $model = new CarNlModel($dbal, (int) $delivery['deliver_id']);
                    break;
                case 2:
                    $model = new CarBeModel($dbal, (int) $delivery['deliver_id']);
                    break;
                default:
                    throw new Exception("Error, site '{$delivery['site']}' is not defined!");
            }
        } else {
            $model = new MotorbikeModel($dbal, (int) $delivery['deliver_id']);
        }

        // Select the correct agreement
        $agreement = (int) $delivery['bedrijvenID'] === 0
            ? new SalesAgreement($model, $emailApiUrl, $location)
            : new PurchaseAgreement($model, $emailApiUrl, $impersonateKey, $dealerdirect);

        // Dump results
        var_dump([
            'site' => $delivery['site'],
            'old' => $old,
            'new-created' => $agreement->create(),
            'new-send' => $agreement->send(),
        ]);
        echo PHP_EOL;
    }
}
