<?php

use Dealerdirect\Agreements\Utils;

$mediationContent = '';
if ($vehicleInfo['sales_agent'] !== 0) {
    sprintf(
        'Diese Verkaufsbestätigung wurde nach Vermittlung durch %s erstellt:' . PHP_EOL . PHP_EOL,
        $vehicleInfo['sales_agent_name']
    );
}
$mediationContent .= implode(
    PHP_EOL,
    [
        'Ichwillmeinmotorradloswerden.de',
        'Fabrikstraße 8',
        '48599 Gronau (Westf.)',
        'Deutschland'
    ]
);

return [
    'sales_agreement_parties1' => implode(
        PHP_EOL,
        [
            sprintf(
                '%s %s',
                strtoupper($vehicleInfo['consumer_first_letters']),
                mb_strtoupper($vehicleInfo['consumer_name'], 'UTF-8')
            ),
            sprintf(
                '%s %s',
                mb_strtoupper($vehicleInfo['consumer_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['consumer_house_number'])
            ),
            sprintf(
                '%s %s',
                strtoupper($vehicleInfo['consumer_zip_code']),
                mb_strtoupper($vehicleInfo['consumer_city'], 'UTF-8')
            ),
            mb_strtoupper($vehicleInfo['consumer_country_name'], 'UTF-8'),
            sprintf(
                'Telefonnummer: %s',
                !empty($vehicleInfo['consumer_mobile'])
                    ? Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_mobile'])
                    : Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_phone'])
            ),
            $vehicleInfo['consumer_email']
        ]
    ),
    'sales_agreement_parties2' => implode(
        PHP_EOL,
        [
            mb_strtoupper($vehicleInfo['company_name'], 'UTF-8'),
            sprintf(
                '%s %s',
                mb_strtoupper($vehicleInfo['company_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['company_house_number'])
            ),
            sprintf(
                '%s %s',
                strtoupper($vehicleInfo['company_zip_code']),
                mb_strtoupper($vehicleInfo['company_city'], 'UTF-8')
            ),
            mb_strtoupper($vehicleInfo['company_country_name'], 'UTF-8'),
            sprintf('Telefonnummer: %s', $vehicleInfo['company_phone'])
        ]
    ),
    'sales_agreement_ownership' => implode(
        PHP_EOL,
        [
            '- Der Verkäufer ist der Besitzer des Motorrads, oder berechtigt sie zu verkaufen;',
            '- Das Fahrzeug ist sowie vorher beschrieben und vermerkt in beiliegende Fahrzeugbeschreibung;',
            '- Der Verkäufer möchte dieses Fahrzeug verkaufen;',
            '- Der Käufer möchte dieses Fahrzeug ankaufen.',
        ]
    ),
    'sales_agreement_vehicle' => sprintf(
        '%s %s. Baujahr: %s Zählerstand: %s %s.',
        strtoupper($vehicleInfo['make']),
        strtoupper($vehicleInfo['model']),
        strtoupper($vehicleInfo['construction_year']),
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type']
    ),
    'sales_agreement_payment' => sprintf(
        'Der Käufer zahlt dem Verkäufer einen Betrag von € %s,- (inkl. MwSt.) in soweit das Fahrzeug ist,'
            . 'sowie in der Beschreibung beschrieben. Der Käufer bezahlt den Verkäufer mit Bargeld '
            . 'oder in beiderseitigem Einverständnis per Banküberweisung.',
        $vehicleInfo['consumer_sale_price']
    ),
    'sales_agreement_delivery' => sprintf(
        'Sowie vorher vereinbart, %s. Die Fahrzeugübergabe muss innerhalb von 14 Tagen stattfinden.',
        $vehicleInfo['pick_up'] === '1'
            ? 'holt der Käufer das Fahrzeug, auf dem vorher vom Verkäufer angegebene Adresse ab'
            : 'soll der Verkäufer das Fahrzeug an der obigen Adresse beim Käufer abgeben'
    ),
    'sales_agreement_mediation' => $mediationContent,
    'brandmodel' => sprintf('%s %s', $vehicleInfo['make'], $vehicleInfo['model']),
    'version' => $vehicleInfo['execution'],
    'buildyear' => sprintf(
        '%s / %s',
        $vehicleInfo['construction_year'],
        Utils::formatDateOrDefault($vehicleInfo['first_ascription'])
    ),
    'miles' => sprintf(
        '%s %s',
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type']
    ),
    'power' => $vehicleInfo['power'],
    'fuel' => $vehicleInfo['fuel'],
    'transmission' => $vehicleInfo['transmission'],
    'colour' => sprintf(
        '%s / %s / %s',
        ucfirst($vehicleInfo['color']),
        ucfirst($vehicleInfo['color_2']),
        ucfirst($vehicleInfo['color_3'])
    ),
    'vat' => $vehicleInfo['marge'],
    'condition_looks' => $vehicleInfo['condition_exterior'],
    'condition_technical' => $vehicleInfo['condition_technical'],
    'condition_profile_front' => $vehicleInfo['condition_front_tyre'],
    'condition_profile_back' => $vehicleInfo['condition_tyre_profile'],
    'condition_propulsion' => $vehicleInfo['condition_propulsion'],
    'condition_damagefree' => $vehicleInfo['condition_damage_free'],
    'comments' => implode(PHP_EOL, [$vehicleInfo['condition_comments'], $vehicleInfo['consumer_comments']]),
    'equipment1' => $vehicleInfo['options'][0],
    'equipment2' => $vehicleInfo['options'][1],
];
