<?php

use Dealerdirect\Agreements\Utils;

$mediationContent = 'Deze overeenkomst werd opgemaakt na bemiddeling door: ';
if ($vehicleInfo['sales_agent'] !== 0) {
    $mediationContent .= $vehicleInfo['sales_agent_name'];
}
$mediationContent .= PHP_EOL . PHP_EOL . implode(
    PHP_EOL,
    [
        'Ikwilvanmijnscooteraf.nl',
        'Josink Maatweg 43',
        '7545 PS Enschede',
        'Nederland'
    ]
);

return [
    'sales_agreement_parties' => implode(
        PHP_EOL . PHP_EOL,
        [
            sprintf(
                '%s %s, wonende te %s %s, %s, %s, %s, bereikbaar op %s hierna aangeduid als "verkoper"',
                strtoupper($vehicleInfo['consumer_first_letters']),
                mb_strtoupper($vehicleInfo['consumer_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['consumer_house_number']),
                strtoupper($vehicleInfo['consumer_zip_code_nl']),
                mb_strtoupper($vehicleInfo['consumer_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_country_name'], 'UTF-8'),
                !empty($vehicleInfo['consumer_mobile'])
                    ? Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_mobile'])
                    : Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_phone'])
            ),
            sprintf(
                'En %s, gevestigd te %s %s, %s, %s, %s, bereikbaar op %s, hierna aangeduid als "koper"',
                mb_strtoupper($vehicleInfo['company_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['company_house_number']),
                strtoupper($vehicleInfo['company_zip_code']),
                mb_strtoupper($vehicleInfo['company_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_country_name'], 'UTF-8'),
                $vehicleInfo['company_phone']
            )
        ]
    ),
    'sales_agreement_status' => 'Het voertuig in de staat verkeert zoals door verkoper aangegeven en vermeld '
        . 'in de bijgevoegde voertuigomschrijving;',
    'sales_agreement_ownership' => implode(
        PHP_EOL,
        [
            sprintf(
                '- Verkoper in het rechtsgeldige bezit is van %s %s, of gemachtigd is deze te verkopen;',
                strtoupper($vehicleInfo['make']),
                strtoupper($vehicleInfo['model'])
            ),
            '- Het voertuig in de staat verkeert zoals door verkoper aangegeven en vermeld in de bijgevoegde '
                . 'voertuigomschrijving;',
            '- Verkoper dit voertuig wenst te verkopen aan koper;',
            '- Koper dit voertuig wenst te kopen.',
        ]
    ),
    'sales_agreement_vehicle' => sprintf(
        'Het voertuig betreft een %s %s uit %s met een tellerstand van %s %s en het volgende kenteken: %s.',
        strtoupper($vehicleInfo['make']),
        strtoupper($vehicleInfo['model']),
        strtoupper($vehicleInfo['construction_year']),
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type'],
        strtoupper($vehicleInfo['license_plate'])
    ),
    'sales_agreement_payment' => sprintf(
        'Koper betaalt aan de verkoper een bedrag van € %s,- (Verkoopbedrag) voor de koop van het voertuig '
            . 'zoals in de omschrijving staat beschreven. Dit bedrag wordt in gezamenlijk overleg in contanten '
            . 'of per bankoverschrijving voldaan aan verkoper.',
        $vehicleInfo['consumer_sale_price']
    ),
    'sales_agreement_delivery' => sprintf(
        'Zoals overeengekomen %s. De overdracht dient binnen 14 dagen volbracht te zijn. ',
        $vehicleInfo['pick_up'] === '1'
            ? 'haalt de koper het voertuig op het door de verkoper aangegeven adres af'
            : 'brengt de verkoper het voertuig naar het adres waar de koper gevestigd is'
    ),
    'sales_agreement_mediation' => $mediationContent,
    'brandmodel' => sprintf('%s %s', $vehicleInfo['make'], $vehicleInfo['model']),
    'version' => $vehicleInfo['execution'],
    'buildyear' => sprintf(
        '%s / %s',
        $vehicleInfo['construction_year'],
        Utils::formatDateOrDefault($vehicleInfo['first_ascription'])
    ),
    'miles' => sprintf(
        '%s %s',
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type']
    ),
    'power' => sprintf('%s kW', $vehicleInfo['power']),
    'fuel' => $vehicleInfo['fuel'],
    'transmission' => $vehicleInfo['transmission'],
    'colour' => sprintf(
        '%s / %s / %s',
        ucfirst($vehicleInfo['color']),
        ucfirst($vehicleInfo['color_2']),
        ucfirst($vehicleInfo['color_3'])
    ),
    'vat' => $vehicleInfo['marge'],
    'condition_looks' => $vehicleInfo['condition_exterior'],
    'condition_technical' => $vehicleInfo['condition_technical'],
    'condition_profile_front' => $vehicleInfo['condition_front_tyre'],
    'condition_profile_back' => $vehicleInfo['condition_tyre_profile'],
    'condition_propulsion' => $vehicleInfo['condition_propulsion'],
    'condition_damagefree' => $vehicleInfo['condition_damage_free'],
    'comments' => implode(PHP_EOL, [$vehicleInfo['condition_comments'], $vehicleInfo['consumer_comments']]),
    'equipment1' => $vehicleInfo['options'][0],
    'equipment2' => $vehicleInfo['options'][1],
];
