<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

use DealerDirect\Generic\Category\DistanceUnit;

final class Vehicle implements DataObject
{
    /**
     * @param int[] $enginePowers
     * @param int[] $colors
     * @param int[] $options
     */
    public function __construct(
        public readonly ?string $brand,
        public readonly ?string $model,
        public readonly ?int $bodyType,
        public readonly ?string $vehicleTrim,
        public readonly ?string $engineCapacity,
        public readonly array $enginePowers,
        public readonly ?int $fuel,
        public readonly ?int $transmission,
        public readonly ?int $odometerReading,
        public readonly ?int $odometerReadingUnit,
        public readonly int $constructionYear,
        public readonly array $colors,
        public readonly ?\DateTime $inspectionValidUntil,
        public readonly ?\DateTime $firstAscriptionDate,
        public readonly ?int $paintType,
        public readonly ?int $upholstery,
        public readonly ?int $marginVat,
        public readonly array $options,
        public readonly ?string $licensePlate,
        public readonly ?string $vin,
        public readonly ?int $registrationPossible,
        public readonly ?int $wokNotification,
        public readonly ?int $bicycleType,
        public readonly ?int $enginePosition,
        public readonly ?int $batteryWattage,
        public readonly ?int $amountOfGears,
        public readonly ?int $oldNewModel,
    ) {
    }

    public function getOdometerReading(bool $withUnit = true): string
    {
        if (null === $this->odometerReading) {
            return '-';
        }

        $result = number_format($this->odometerReading, 0, ',', '.');
        if ($withUnit) {
            $result .= ' ' . (DistanceUnit::MILES === $this->odometerReadingUnit ? 'mi' : 'km');
        }

        return $result;
    }
}
