<?php

use Dealerdirect\Generic\Category\BatteryWattage;
use Dealerdirect\Generic\Category\BicycleType;
use Dealerdirect\Generic\Category\EnginePosition;

return [
    'battery_wattage' => [
        BatteryWattage::DOES_NOT_APPLY => 'n.v.t.',
        BatteryWattage::BETWEEN_300_AND_399 => '300 - 399 Watt',
        BatteryWattage::BETWEEN_400_AND_499 => '400 - 499 Watt',
        BatteryWattage::BETWEEN_500_AND_599 => '500 - 599 Watt',
        BatteryWattage::BETWEEN_600_AND_699 => '600 - 699 Watt',
        BatteryWattage::BETWEEN_700_AND_799 => '700 - 799 Watt',
        BatteryWattage::BETWEEN_800_AND_899 => '800 - 899 Watt',
        BatteryWattage::BETWEEN_900_AND_999 => '900 - 999 Watt',
        BatteryWattage::BETWEEN_1000_AND_1099 => '1000 - 1099 Watt',
        BatteryWattage::BETWEEN_1100_AND_1199 => '1100 - 1199 Watt',
        BatteryWattage::BETWEEN_1200_AND_1299 => '1200 - 1299 Watt',
        BatteryWattage::BETWEEN_1300_AND_1400 => '1300 - 1400 Watt',
    ],
    'engine_position' => [
        EnginePosition::DOES_NOT_APPLY => 'n.v.t.',
        EnginePosition::FRONT => 'Voor',
        EnginePosition::CENTER => 'Midden',
        EnginePosition::BACK => 'Achter',
    ],
    'bicycle_type' => [
        0 => 'Onbekend',
        BicycleType::ELECTRIC_LADIES_BIKE => '(Elektrische) Damesfiets',
        BicycleType::ELECTRIC_MENS_BIKE => '(Elektrische) Herenfiets',
        BicycleType::ELECTRIC_TRICYCLE => '(Elektrische) Driewieler',
        BicycleType::ELECTRIC_MOUNTAIN_BIKE => '(Elektrische) Mountainbike',
        BicycleType::RACING_BIKE => 'Racefiets',
        BicycleType::ELECTRIC_CARGO_BIKE => '(Elektrische) Bakfiets',
    ],
];
