<?php

/**
 * @var Dealerdirect\Agreements\Pdf\Templates\SalesAgreement $this
 * @var object                                               $data
 */
?>
<!DOCTYPE html>
<html>
<head>
    <title><?=$this->translate('labels.sales_agreement')?></title>
    <style><?=file_get_contents(__DIR__ . '/css/marktplaats-sales-agreement.css')?></style>
</head>
<body>
    <div class="header">
        <div class="header_container">
            <img src="<?=$this->getLogo()?>" />
            <h1><?=$this->translate('labels.sales_agreement')?></h1>
        </div>
        <div class="triangle"></div>
    </div>

    <div class="container border">
        <div class="content">
            <div class="border-bottom">
                <h2><?=$this->translate('labels.parties_mp')?></h2>
            </div>
            <div class="parties">
                <?php foreach ($this->getParties() as $party) : ?>
                    <p><?=$party?></p>
                <?php endforeach; ?>
            </div>

            <?php if (!empty($consideration = $this->getConsideration())) : ?>
                <div class="border-bottom">
                    <h2><?=$consideration['title']?></h2>
                </div>
                <p><?=nl2br($consideration['content'])?></p>
            <?php endif; ?>

            <?php if (!empty($agreement = $this->getAgreements())) : ?>
                <div class="border-bottom">
                    <h2><?=$agreement['title']?></h2>
                </div>
                <?php foreach ($agreement['parts'] as $key => $agreementPart) : ?>
                    <div class="consider-step">
                        <h3><?=$key + 1?>. <?=$agreementPart['title']?></h3>
                        <p><?=nl2br($agreementPart['content'])?></p>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

            <?php if (!empty($mediation = $this->getMediation())) : ?>
                <div class="border-bottom">
                    <h2><?=$mediation['title']?></h2>
                </div>
                <p><?=nl2br($mediation['content'])?></p>
            <?php endif; ?>
        </div>
    </div>
    <div class="container">
        <div class="content">
            <div class="block">
                <h2><?=$this->translate('labels.general')?></h2>
                <table>
                    <?php foreach ($this->getVehicleValues() as $vehicleValue) : ?>
                        <tr>
                            <td><h3><?=$vehicleValue['label']?></h3></td>
                            <td><p><?=$vehicleValue['value']?></p></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>

            <div class="block">
                <h2><?=$this->translate('labels.condition')?></h2>
                <table>
                    <?php foreach ($this->getConditions() as $condition) : ?>
                        <tr>
                            <td><h3><?=$condition['label']?></h3></td>
                            <td><p><?=$condition['value']?></p></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
            <div class="block">
                <h2><?=$this->translate('labels.equipment')?></h2>
                <table>
                    <!-- foreach 2 items open and close a tr -->
                    <?php foreach ($this->data->vehicle->options as $key => $option) : ?>
                        <?=(0 === $key % 2) ? '<tr>' : ''?>
                        <td class="no-border">
                            <p><?=$this->translate('options.' . $option)?></p>
                        </td>
                        <?=(0 !== $key % 2) ? '</tr>' : ''?>
                    <?php endforeach; ?>
                </table>
            </div>
        </div>
    </div>

    <?php if (!empty($data->checklist)) : ?>
    <div class="container">
        <div class="content">
            <h2><?=$this->translate('labels.checklist')?></h2>
            <table>
            <?php foreach ($data->checklist as $checklistItem) : ?>
                <?php if (empty($checklistItem['answer']) || '-' === $checklistItem['answer']) {
                    // Skip empty checklist items
                    continue;
                } ?>
                <tr>
                    <td><h3><?=$checklistItem['question']?></h3></td>
                    <td><p><?=$checklistItem['answer']?></p></td>
                </tr>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($data->internalComments) || !empty($data->consumerComments)) : ?>
    <div class="container">
        <div class="content">
            <?php if (!empty($data->internalComments)) : ?>
                    <h2><?=$this->translate('labels.internal_comment')?></h2>
                    <p><?=nl2br($data->internalComments)?></p>
            <?php endif; ?>

            <?php if (!empty($data->consumerComments)) : ?>
                    <h2><?=$this->translate('labels.consumer_comment')?></h2>
                    <p><?=nl2br($data->consumerComments)?></p>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
</body>
</html>
