<?php

use Dealerdirect\Agreements\Pdf\Templates\MotorbikeSalesAgreement;

/**
 * @var Dealerdirect\Agreements\Pdf\Templates\SalesAgreement $this
 * @var object                                               $data
 */

$isMotorbike = $this instanceof MotorbikeSalesAgreement;
?>
<!DOCTYPE html>
<html>
<head>
    <title><?=$this->translate('labels.sales_agreement')?></title>
    <style><?=file_get_contents(__DIR__ . '/css/sales-agreement.css')?></style>
</head>
<body>
    <div class="container border smaller">
        <div class="header">
            <img src="<?=$this->getLogo()?>" />
            <h1><?=$this->translate('labels.sales_agreement')?></h1>
        </div>

        <div class="content">
            <div class="border-bottom">
                <h2><?=$this->translate('labels.parties')?></h2>
            </div>
            <div class="parties divided">
                <?php foreach ($this->getParties() as $party) : ?>
                    <p><?=nl2br($party)?></p>
                <?php endforeach; ?>
            </div>

            <div style="clear: both;"></div>

            <?php if (!empty($consideration = $this->getConsideration())) : ?>
                <div class="border-bottom">
                    <h2><?=$consideration['title']?></h2>
                </div>
                <p><?=nl2br($consideration['content'])?></p>
            <?php endif; ?>

            <?php if (!empty($agreement = $this->getAgreements())) : ?>
                <div class="border-bottom">
                    <h2><?=$agreement['title']?></h2>
                </div>
                <?php foreach ($agreement['parts'] as $key => $agreementPart) : ?>
                    <div class="consider-step">
                        <h3><?=$key + 1?>. <?=$agreementPart['title']?></h3>
                        <p><?=nl2br($agreementPart['content'])?></p>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

            <?php if (!empty($mediation = $this->getMediation())) : ?>
                <div class="border-bottom">
                    <h2><?=$mediation['title']?></h2>
                </div>
                <p><?=nl2br($mediation['content'])?></p>
            <?php endif; ?>
        </div>
        <img class="wax-stamp" src="<?=$this->getStamp()?>" />
    </div>
    <div class="new-page"></div>
    <div class="container">
        <div class="header">
            <img src="<?=$this->getLogo()?>" />
            <h1><?=$this->translate('labels.vehicle_description')?></h1>
        </div>
        <div class="content">
            <div class="block">
                <h2><?=$this->translate('labels.general')?></h2>
                <table>
                    <?php foreach ($this->getVehicleValues() as $vehicleValue) : ?>
                        <tr class="border-bottom">
                            <td><h3><?=$vehicleValue['label']?></h3></td>
                            <td><p><?=$vehicleValue['value']?></p></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>

            <div class="block">
                <h2><?=$this->translate('labels.condition')?></h2>
                <table>
                    <?php foreach ($this->getConditions() as $condition) : ?>
                        <tr class="border-bottom">
                            <td><h3><?=$condition['label']?></h3></td>
                            <td><p><?=$condition['value']?></p></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>

            <?php if (!empty($this->data->vehicle->options)) : ?>
                <div class="block">
                    <h2><?=$this->translate('labels.equipment')?></h2>
                    <table>
                        <?php foreach ($this->data->vehicle->options as $key => $option) : ?>
                            <?=(0 === $key % 2) ? '<tr>' : ''?>
                            <td class="no-border">
                                <p><?=$this->translate('options.' . $option)?></p>
                            </td>
                            <?=(0 !== $key % 2) ? '</tr>' : ''?>
                        <?php endforeach; ?>
                    </table>
                </div>
            <?php endif; ?>

            <?php if (!empty($data->checklist)) : ?>
                <div class="block">
                    <h2><?=$this->translate('labels.checklist')?></h2>
                    <table>
                    <?php foreach ($data->checklist as $checklistItem) : ?>
                        <?php if (empty($checklistItem['answer']) || '-' === $checklistItem['answer']) {
                            // Skip empty checklist items
                            continue;
                        } ?>

                        <tr class="border-bottom">
                            <td><h3><?=$checklistItem['question']?></h3></td>
                            <td><p><?=$checklistItem['answer']?></p></td>
                        </tr>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($data->internalComments)) : ?>
                <div class="block">
                    <h2><?=$this->translate('labels.internal_comment')?></h2>
                    <p><?=nl2br($data->internalComments)?></p>
                </div>
            <?php endif; ?>

            <?php if (!empty($data->consumerComments)) : ?>
                <div class="block">
                    <h2><?=$this->translate('labels.consumer_comment')?></h2>
                    <p><?=nl2br($data->consumerComments)?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
