<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class SalesAgreementNotStoredException extends \Exception
{
    public function __construct(
        int $lotId,
        int $companyId,
        int $siteReference,
        string $storageName,
    ) {
        parent::__construct(sprintf(
            'The agreement for lot %d, company %d and site reference %d was not stored with name %s',
            $lotId,
            $companyId,
            $siteReference,
            $storageName
        ));
    }
}
