<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class FetchPurchaseAgreementPdfException extends \Exception
{
    public function __construct(
        int $lotId,
        int $dealerId,
        string $locale,
        string $vehicleType,
        ?int $statusCode = null,
        ?string $contentType = null
    ) {
        $message = sprintf(
            'Failed to fetch the purchase agreement PDF for lot %d, dealer %d, locale %s, vehicle type %s',
            $lotId,
            $dealerId,
            $locale,
            $vehicleType
        );

        if (null !== $statusCode) {
            $message .= sprintf(', status code %d', $statusCode);
        }

        if (null !== $contentType) {
            $message .= sprintf(', content type %s', $contentType);
        }

        parent::__construct($message);
    }
}
