<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

use Dealerdirect\Agreements\Pdf\Templates\AbstractTemplate;

final class PdfGenerationException extends \RuntimeException
{
    public function __construct(AbstractTemplate $template)
    {
        $class = get_class($template);

        parent::__construct("Failed to generate PDF for template: '{$class}'");
    }
}
