#!/usr/bin/env php

<?php

require_once dirname(__DIR__) . '/vendor/autoload.php';

use Dealerdirect\Agreements\DataObjects\Font;

$resourcesFolder = dirname(__DIR__) . '/resources';

$customFonts = [
    new Font('ARegular', 'normal', "$resourcesFolder/fonts/Regular-Regular.ttf"),
    new Font('ARegular', 'bold', "$resourcesFolder/fonts/Regular-Bold.ttf"),
    new Font('Roboto', 'normal', "$resourcesFolder/fonts/Roboto-Regular.ttf"),
    new Font('Bree Serif', 'normal', "$resourcesFolder/fonts/BreeSerif-Regular.ttf"),
];

$printMessage = false;
$domPdf = new Dompdf\Dompdf();
$fontMetrics = $domPdf->getFontMetrics();

foreach ($customFonts as $font) {
    if (!$fontMetrics->getFont($font->family, $font->weight)) {
        echo sprintf("Registering font: %-10s - %s\n", $font->family, $font->weight);

        $font->register($fontMetrics);
        $printMessage = true;
    }
}

if ($printMessage) {
    echo "Fonts installed successfully\n";
}
