<?php

// phpcs:disable PSR1.Files.SideEffects

declare(strict_types=1);

error_reporting(E_ALL | E_DEPRECATED | E_STRICT);
ini_set('display_errors', 'On');
ini_set('display_startup_errors', 'On');

use DealerDirect\Generic\Category\Site;
use DealerDirect\Sdk\Config;
use DealerDirect\Sdk\Facade\Email;
use DealerDirect\Sdk\Sdk;
use Doctrine\DBAL\DriverManager;
use Illuminate\Filesystem\FilesystemAdapter;
use League\Flysystem\Filesystem;
use League\Flysystem\Local\LocalFilesystemAdapter;

require_once dirname(__DIR__) . '/vendor/autoload.php';

$_SERVER['REMOTE_ADDR'] = '127.0.0.1';
$reference = (int) ($_GET['reference'] ?? Site::REF_CAR_NL);
$project = $_GET['project'] ?? $reference;
$deliverId = (int) ($_GET['deliver_id'] ?? 99141);
$showFile = in_array($_GET['show_file'] ?? false, [true, 'true', 1, '1'], true);

$reference = match ($project) {
    Site::REF_CAR_NL, 'car_nl' => Site::REF_CAR_NL,
    Site::REF_CAR_BE_NL, 'car_be' => Site::REF_CAR_BE_NL,
    Site::REF_CAR_MARKTPLAATS_NL, 'marktplaats_nl' => Site::REF_CAR_MARKTPLAATS_NL,
    Site::REF_MOTO_NL, 'motorbike_nl' => Site::REF_MOTO_NL,
    Site::REF_MOTO_BE, 'motorbike_be' => Site::REF_MOTO_BE,
    Site::REF_MOTO_DE, 'motorbike_de' => Site::REF_MOTO_DE,
    Site::REF_BICYCLE_NL, 'bicycle_nl' => Site::REF_BICYCLE_NL,
    Site::REF_SCOOTER_NL, 'scooter_nl' => Site::REF_SCOOTER_NL,
    default => throw new Exception("Error, project or reference '$project' is not defined!"),
};

function getStorage(string $path): FilesystemAdapter
{
    if (!is_dir($path)) {
        mkdir($path, 0777, true);
    }

    $localFileSystem = new LocalFilesystemAdapter($path);
    $fileSystem = new Filesystem($localFileSystem);

    return new FilesystemAdapter($fileSystem, $localFileSystem);
}

function getEmailClient(): Email
{
    $sdkConfig = new Config([Config::EMAIL_SERVICE_URL => 'https://email-service.aio.test/api/v1']);
    $sdk = new Sdk($sdkConfig);

    return $sdk->getEmail();
}

function getConnection(): \Doctrine\DBAL\Connection
{
    return DriverManager::getConnection([
        'dbname' => 'dealer01_ddmain',
        'user' => 'vagrant',
        'password' => 'vagrant',
        'host' => 'aio.test',
        'driver' => 'pdo_mysql',
    ], new \Doctrine\DBAL\Configuration());
}
