<?php

use Dealerdirect\Agreements\Factory;

require_once __DIR__ . '/bootstrap.php';

$dealerdirectUrl = 'https://dealerdirect.eu.aio.test';
$impersonateKey = 'R72SaMOwBou595zLuW1HtPHkYZd6og1T';

$purchaseAgreementFactory = Factory::forPurchaseAgreement(
    getStorage('/tmp/purchase-agreements'),
    Factory::getModelByReference($reference, getConnection(), $deliverId),
    $impersonateKey,
    $dealerdirectUrl
);

$purchaseAgreementFactory->delete();
$purchaseAgreementFactory->create();

if (!$showFile) {
    $purchaseAgreementFactory->send(getEmailClient(), ['dealerdirect' => $dealerdirectUrl]);

    echo 'Purchase Agreement is created and send';
    exit;
}

header('Content-Type: application/pdf');
echo $purchaseAgreementFactory->show();
