<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

use Dealerdirect\Agreements\Exceptions\FileNotFoundException;
use Dompdf\FontMetrics;

final class Font
{
    public function __construct(
        public readonly string $family,
        public readonly string $weight,
        public readonly string $file,
        public readonly ?string $style = null,
    ) {
        if (!file_exists($file)) {
            throw new FileNotFoundException($file);
        }
    }

    public function register(FontMetrics $fontMetrics): void
    {
        $destFile = sprintf('%s/%s', $fontMetrics->getOptions()->getFontDir(), basename($this->file));
        if (!file_exists($destFile)) {
            copy($this->file, $destFile);
        }

        $fontMetrics->registerFont([
            'family' => $this->family,
            'weight' => $this->weight,
            'style' => $this->style,
        ], $destFile);
    }
}
