<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Factories;

use DealerDirect\Sdk\Facade\Email;

interface Factory
{
    public function create(): void;

    public function show(): string;

    public function delete(): void;

    public function exists(): bool;

    public function store(string $pdfContent): void;

    public function send(Email $emailClient, ?array $domains = null, ?string $encryptionKey = null): void;

    public function getStorageName(): string;
}
