<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\Pdf\Templates;

use Dealerdirect\Agreements\Enums\Locale;
use Dealerdirect\Agreements\Pdf\Templates\MarktplaatsSalesAgreement;
use Dealerdirect\Agreements\Tests\TestCase;
use Dealerdirect\Agreements\Tests\Traits\DataObjectFixtures;

/**
 * @covers \Dealerdirect\Agreements\Pdf\Templates\MarktplaatsSalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\CarSalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\SalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\AbstractTemplate
 *
 * @uses Dealerdirect\Agreements\DataObjects\Agent
 * @uses Dealerdirect\Agreements\DataObjects\Conditions
 * @uses Dealerdirect\Agreements\DataObjects\Contact
 * @uses Dealerdirect\Agreements\DataObjects\SalesAgreement
 * @uses Dealerdirect\Agreements\DataObjects\Vehicle
 */
final class MarktplaatsSalesAgreementTest extends TestCase
{
    use DataObjectFixtures;

    public function test_can_construct_with_all_locales(): void
    {
        $this->expectNotToPerformAssertions();

        $translator = $this->createStub(\Dealerdirect\Agreements\Utils\Translator::class);
        $translator->method('get')->willReturn('translated string');

        new MarktplaatsSalesAgreement(Locale::NL_NL, $this->fixtureSalesAgreement(), $translator);
    }

    /**
     * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
     */
    public function test_render_returns_valid_html(): void
    {
        $translator = $this->createStub(\Dealerdirect\Agreements\Utils\Translator::class);
        $translator->method('get')->willReturn('translated string');

        $template = new MarktplaatsSalesAgreement(Locale::NL_NL, $this->fixtureSalesAgreement(), $translator);

        $this->assertStringIsValidHtml($template->render(), 'Template should render valid HTML');
    }

    /**
     * @uses \Dealerdirect\Agreements\DataObjects\Font
     */
    public function test_get_fonts(): void
    {
        $translator = $this->createStub(\Dealerdirect\Agreements\Utils\Translator::class);
        $translator->method('get')->willReturn('translated string');

        $template = new MarktplaatsSalesAgreement(Locale::NL_NL, $this->fixtureSalesAgreement(), $translator);

        $fonts = $template->getFonts();

        $this->assertIsArray($fonts);
        $this->assertCount(2, $fonts);

        $this->assertSame('Roboto', $fonts[0]->family);
        $this->assertSame('normal', $fonts[0]->weight);

        $this->assertSame('Bree Serif', $fonts[1]->family);
        $this->assertSame('normal', $fonts[1]->weight);
    }

    private function fixtureData(): array
    {
        return [
            'title' => 'Verkoopovereenkomst',
            'logo' => 'svg',
            'sales_agreement_first_party' => '',
            'sales_agreement_second_party' => '',
            'sales_agreement_status' => '',
            'sales_agreement_ownership' => '',
            'sales_agreement_description' => '',
            'sales_agreement_payment' => '',
            'sales_agreement_delivery' => '',
            'sales_agreement_mediation' => '',
            'first_admission' => '',
            'brandmodel' => '',
            'upholstery' => '',
            'transmission' => '',
            'construction_year' => '',
            'inspection_valid_until' => '',
            'body_type' => '',
            'condition_tire_profile' => '',
            'condition_interior' => '',
            'condition_exterior' => '',
            'drivable' => '',
            'damage_free' => '',
            'vehicle_trim' => '',
            'engine_power' => '',
            'engine_capacity' => '',
            'odometer_reading' => '',
            'color' => '',
            'paint_type' => '',
            'fuel_type' => '',
            'margin_vat' => '',
            'condition_technical' => '',
            'equipment1' => '',
            'equipment2' => '',
            'comments_consumer' => '',
            'comments_internal' => '',
        ];
    }
}
