<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

/**
 * @codeCoverageIgnore
 */
final class Conditions implements DataObject
{
    public function __construct(
        public readonly int $exterior,
        public readonly int $technical,
        public readonly int $drivable,
        public readonly int $damageFree,
        public readonly int $interior,
        public readonly int $tireProfile,
        public readonly int $frontTireProfile,
        public readonly int $rearTireProfile,
        public readonly int $propulsion,
        public readonly int $general,
        public readonly int $battery,
    ) {
    }
}
