<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

use Dealerdirect\Agreements\Utils\Translator;

final class Contact implements DataObject
{
    /**
     * @param string[] $phoneNumbers
     * @param string[] $emails
     */
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $name,
        public readonly ?string $firstName,
        public readonly ?string $lastName,
        public readonly ?int $salutation,
        public readonly string $streetName,
        public readonly string $houseNumber,
        public readonly string $zipCode,
        public readonly string $city,
        public readonly int $country,
        public readonly array $phoneNumbers,
        public readonly array $emails
    ) {
    }

    /**
     * @return string[]
     */
    public function getValidEmails(): array
    {
        return array_filter($this->emails, fn (string $email) => filter_var($email, FILTER_VALIDATE_EMAIL) !== false);
    }

    public function getAddress(): string
    {
        return sprintf(
            '%s %s, %s, %s, %s',
            $this->streetName,
            $this->houseNumber,
            $this->zipCode,
            $this->city,
            Translator::translate("general.country.$this->country"),
        );
    }

    public function getName(): string
    {
        return $this->name ?? trim("{$this->firstName} {$this->lastName}");
    }
}
