<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class InvalidTranslationValueException extends \Exception
{
    public function __construct(string $key, mixed $value)
    {
        parent::__construct(sprintf(
            'Invalid translation value for key "%s": %s',
            $key,
            var_export($value, true)
        ));
    }
}
