<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests;

use Dealerdirect\Agreements\Factories\PurchaseAgreementFactory;
use Dealerdirect\Agreements\Factories\SalesAgreementFactory;
use Dealerdirect\Agreements\Factory;
use Dealerdirect\Agreements\Tests\Models\CarNlModelTest;
use Doctrine\DBAL\Connection;
use Illuminate\Filesystem\FilesystemAdapter;

/**
 * @covers \Dealerdirect\Agreements\Factory
 *
 * @uses \Dealerdirect\Agreements\DataObjects\Contact
 * @uses \Dealerdirect\Agreements\DataObjects\Font
 * @uses \Dealerdirect\Agreements\Enums\Locale
 * @uses \Dealerdirect\Agreements\Models\AbstractModel
 * @uses \Dealerdirect\Agreements\Models\CarModel
 * @uses \Dealerdirect\Agreements\Models\CarNlModel
 * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
 * @uses \Dealerdirect\Agreements\Utils\Translator
 * @uses \Dealerdirect\Agreements\DataObjects\Vehicle
 */
final class FactoryTest extends TestCase
{
    /**
     * @uses \Dealerdirect\Agreements\Pdf\Generator
     * @uses \Dealerdirect\Agreements\Pdf\Templates\AbstractTemplate
     * @uses \Dealerdirect\Agreements\Pdf\Templates\CarSalesAgreement
     * @uses \Dealerdirect\Agreements\Pdf\Templates\SalesAgreement
     * @uses \Dealerdirect\Agreements\Utils\CommentsFormatter
     * @uses \Dealerdirect\Agreements\Factories\SalesAgreementFactory
     */
    public function test_for_sales_agreement(): void
    {
        $connection = $this->createMock(Connection::class);
        $connection->expects($this->once())
            ->method('fetchAssociative')
            ->willReturn(CarNlModelTest::fixtureFetchSaleData())
        ;

        $salesAgreement = Factory::forSalesAgreement(
            $this->createMock(FilesystemAdapter::class),
            Factory::getModelByReference(1, $connection, 1),
        );

        $this->assertInstanceOf(SalesAgreementFactory::class, $salesAgreement);
    }

    /**
     * @uses \Dealerdirect\Agreements\DataObjects\PurchaseAgreement
     * @uses \Dealerdirect\Agreements\Factories\PurchaseAgreementFactory
     */
    public function test_for_purchase_agreement(): void
    {
        $connection = $this->createMock(Connection::class);
        $connection->expects($this->once())
            ->method('fetchAssociative')
            ->willReturn(CarNlModelTest::fixtureFetchPurchaseData())
        ;

        $purchaseAgreement = Factory::forPurchaseAgreement(
            $this->getMockForStorage(),
            Factory::getModelByReference(1, $connection, 1),
            'fake-impersonate-key',
            'dealerdirect.eu'
        );

        $this->assertInstanceOf(PurchaseAgreementFactory::class, $purchaseAgreement);
    }
}
