<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class FetchPurchaseAgreementPdfException extends \Exception
{
    public function __construct(int $lotId, int $dealerId, string $locale, string $vehicleType, ?int $statusCode = null)
    {
        parent::__construct(sprintf(
            'Failed to fetch purchase agreement pdf (lotId: %d, dealerId %d, Locale: %s [%s], status code: %d)',
            $lotId,
            $dealerId,
            $locale,
            $vehicleType,
            $statusCode ?? 0
        ));
    }
}
