<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Mailers;

use Dealerdirect\Agreements\DataObjects\DataObject;
use Dealerdirect\Agreements\Exceptions\EmptyRecipientsException;
use Dealerdirect\Sdk\Facade\Email as EmailClient;
use Dealerdirect\Sdk\Model\Email\Email;

abstract class Mailer
{
    public function __construct(
        protected EmailClient $client,
        protected Email $email,
        protected DataObject $data,
    ) {
    }

    public function send(): void
    {
        $recipients = $this->getRecipients();
        if (empty($recipients)) {
            throw new EmptyRecipientsException();
        }

        $this->client->sendEmail($this->email, $recipients, $this->getCc(), $this->getBcc());
    }

    /**
     * @return \Dealerdirect\Sdk\Model\Email\Recipient[]
     */
    abstract public function getRecipients(): array;

    /**
     * @return \Dealerdirect\Sdk\Model\Email\Recipient[]
     */
    abstract public function getCc(): array;

    /**
     * @return \Dealerdirect\Sdk\Model\Email\Recipient[]
     */
    abstract public function getBcc(): array;
}
