<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\DataObjects;

use Dealerdirect\Agreements\DataObjects\Contact;
use Dealerdirect\Agreements\Tests\TestCase;
use Dealerdirect\Agreements\Tests\Traits\DataObjectFixtures;
use Dealerdirect\Agreements\Utils\Translator;
use Dealerdirect\Generic\Category\Site;

/**
 * @covers \Dealerdirect\Agreements\DataObjects\Contact
 */
final class ContactTest extends TestCase
{
    use DataObjectFixtures;

    public function test_method_get_name_for_company(): void
    {
        $contact = $this->fixtureCompany();

        $this->assertSame('Autoboer B.V.', $contact->getName());
    }

    public function test_method_get_name_for_consumer(): void
    {
        $contact = $this->fixtureConsumer();

        $this->assertSame('Sjaak Afhaak', $contact->getName());
    }

    public function test_method_get_valid_emails(): void
    {
        $contact = $this->fixtureConsumer();
        $data = get_object_vars($contact);
        $data['emails'][] = 'invalid-email';

        $contact = new Contact(...$data);

        $this->assertSame(['a.b@c.de'], $contact->getValidEmails());
    }

    /**
     * @uses \Dealerdirect\Agreements\Utils\Translator
     * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
     * @uses \Dealerdirect\Agreements\Enums\Locale
     */
    public function test_method_get_address(): void
    {
        Translator::create(Site::REF_CAR_NL);
        $contact = $this->fixtureConsumer();

        $this->assertSame('Main Street 123, 1234 AB, Amsterdam, Nederland', $contact->getAddress());
    }
}
