<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\Models;

use Dealerdirect\Agreements\Models\AbstractModel;
use Dealerdirect\Agreements\Models\CarBeModel;
use Dealerdirect\Agreements\Tests\TestCase;
use Doctrine\DBAL\Connection;

/**
 * @covers \Dealerdirect\Agreements\Models\CarBeModel
 * @covers \Dealerdirect\Agreements\Models\CarModel
 * @covers \Dealerdirect\Agreements\Models\AbstractModel
 *
 * @uses \Dealerdirect\Agreements\DataObjects\Contact
 * @uses \Dealerdirect\Agreements\Enums\Locale
 * @uses \Dealerdirect\Agreements\Utils\CommentsFormatter
 * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
 * @uses \Dealerdirect\Agreements\DataObjects\PurchaseAgreement
 * @uses \Dealerdirect\Agreements\DataObjects\SalesAgreement
 * @uses \Dealerdirect\Agreements\DataObjects\Vehicle
 */
final class CarBeModelTest extends TestCase
{
    use TestCases;

    public function getModel(Connection $connection, ?int $deliverId = 1): AbstractModel
    {
        return new CarBeModel($connection, $deliverId);
    }

    public function getTable(): string
    {
        return 'dealer01_ddmain.verkopen_levering_be';
    }

    public function getLogTable(): string
    {
        return 'dealer01_ddmain.verkopen_levering_be_log';
    }
}
