<?php

use Dealerdirect\Agreements\Utils;
use Dealerdirect\Generic\Category\BatteryWattage;
use Dealerdirect\Generic\Category\BicycleType;
use Dealerdirect\Generic\Category\EnginePosition;

$mediationContent = 'Deze overeenkomst werd opgemaakt na bemiddeling door: ';
if ($vehicleInfo['sales_agent'] !== 0) {
    $mediationContent .= $vehicleInfo['sales_agent_name'];
}
$mediationContent .= PHP_EOL . PHP_EOL . implode(
    PHP_EOL,
    [
        'Ikwilvanmijnfietsaf.nl',
        'Josink Maatweg 43',
        '7545 PS Enschede',
        'Nederland'
    ]
);

return [
    'sales_agreement_parties' => implode(
        PHP_EOL . PHP_EOL,
        [
            sprintf(
                '%s %s, wonende te %s %s, %s, %s, %s, bereikbaar op %s of %s, hierna aangeduid als "verkoper"',
                strtoupper($vehicleInfo['consumer_first_letters']),
                mb_strtoupper($vehicleInfo['consumer_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['consumer_house_number']),
                strtoupper($vehicleInfo['consumer_zip_code_nl']),
                mb_strtoupper($vehicleInfo['consumer_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_country_name'], 'UTF-8'),
                !empty($vehicleInfo['consumer_mobile'])
                    ? Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_mobile'])
                    : Utils::sanitizePhoneNumber($vehicleInfo['consumer_country'], $vehicleInfo['consumer_phone']),
                $vehicleInfo['consumer_email']
            ),
            sprintf(
                'En %s, gevestigd te %s %s, %s, %s, %s, bereikbaar op %s of %s, hierna aangeduid als "koper"',
                mb_strtoupper($vehicleInfo['company_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['company_house_number']),
                strtoupper($vehicleInfo['company_zip_code']),
                mb_strtoupper($vehicleInfo['company_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_country_name'], 'UTF-8'),
                $vehicleInfo['company_phone'],
                $vehicleInfo['company_agree_email']
            )
        ]
    ),
    'sales_agreement_status' => 'Het voertuig in de staat verkeert zoals door verkoper aangegeven en vermeld '
        . 'in de bijgevoegde voertuigomschrijving;',
    'sales_agreement_ownership' => implode(
        PHP_EOL,
        [
            sprintf(
                '- Verkoper in het rechtsgeldige bezit is van %s %s, of gemachtigd is deze te verkopen;',
                strtoupper($vehicleInfo['make']),
                strtoupper($vehicleInfo['model'])
            ),
            '- Het voertuig in de staat verkeert zoals door verkoper aangegeven en vermeld in de bijgevoegde '
                . 'voertuigomschrijving;',
            '- Verkoper dit voertuig wenst te verkopen aan koper;',
            '- Koper dit voertuig wenst te kopen.',
        ]
    ),
    'sales_agreement_vehicle' => sprintf(
        'Het voertuig betreft een %s %s uit %s met een tellerstand van %s %s.',
        strtoupper($vehicleInfo['make']),
        strtoupper($vehicleInfo['model']),
        strtoupper($vehicleInfo['construction_year']),
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type']
    ),
    'sales_agreement_payment' => sprintf(
        'Koper betaalt aan de verkoper een bedrag van € %s,- (Verkoopbedrag) voor de koop van het voertuig '
            . 'zoals in de omschrijving staat beschreven. Dit bedrag wordt in gezamenlijk overleg in contanten '
            . 'of per bankoverschrijving voldaan aan verkoper.',
        $vehicleInfo['consumer_sale_price']
    ),
    'sales_agreement_delivery' => sprintf(
        'Zoals overeengekomen %s. De overdracht dient binnen 14 dagen volbracht te zijn. ',
        $vehicleInfo['pick_up'] == '1'
            ? 'haalt de koper het voertuig op het door de verkoper aangegeven adres af'
            : 'brengt de verkoper het voertuig naar het adres waar de koper gevestigd is'
    ),
    'sales_agreement_mediation' => $mediationContent,
    'merkmodel' => sprintf('%s %s', $vehicleInfo['make'], $vehicleInfo['model']),
    'bouwjaar' => $vehicleInfo['construction_year'],
    'tellerstand' => empty($vehicleInfo['mileage']) ? 'Onbekend' : sprintf(
        '%s %s',
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        $vehicleInfo['mileage_type']
    ),
    'soort' => [
        BicycleType::ELECTRIC_LADIES_BIKE => '(Elektrische) Damesfiets',
        BicycleType::ELECTRIC_MENS_BIKE => '(Elektrische) Herenfiets',
        BicycleType::ELECTRIC_TRICYCLE => '(Elektrische) Driewieler',
        BicycleType::ELECTRIC_MOUNTAIN_BIKE => '(Elektrische) Mountainbike',
        BicycleType::RACING_BIKE => 'Racefiets',
    ][$vehicleInfo['bicycle_type']] ?? 'Onbekend',
    'motorpositie' => [
        EnginePosition::DOES_NOT_APPLY => 'n.v.t.',
        EnginePosition::FRONT => 'Voor',
        EnginePosition::CENTER => 'Midden',
        EnginePosition::BACK => 'Achter',
    ][$vehicleInfo['engine_position']] ?? 'Onbekend',
    'accuwattage' => [
        BatteryWattage::DOES_NOT_APPLY => 'n.v.t.',
        BatteryWattage::BETWEEN_300_AND_399 => '300 - 399 Watt',
        BatteryWattage::BETWEEN_400_AND_499 => '400 - 499 Watt',
        BatteryWattage::BETWEEN_500_AND_599 => '500 - 599 Watt',
        BatteryWattage::BETWEEN_600_AND_699 => '600 - 699 Watt',
        BatteryWattage::BETWEEN_700_AND_799 => '700 - 799 Watt',
        BatteryWattage::BETWEEN_800_AND_899 => '800 - 899 Watt',
        BatteryWattage::BETWEEN_900_AND_999 => '900 - 999 Watt',
        BatteryWattage::BETWEEN_1000_AND_1099 => '1000 - 1099 Watt',
        BatteryWattage::BETWEEN_1100_AND_1199 => '1100 - 1199 Watt',
        BatteryWattage::BETWEEN_1200_AND_1299 => '1200 - 1299 Watt',
        BatteryWattage::BETWEEN_1300_AND_1400 => '1300 - 1400 Watt',
    ][$vehicleInfo['battery_wattage']] ?? 'Onbekend',
    'aantalversnellingen' => $vehicleInfo['gears'],
    'kleur' => $vehicleInfo['color'],
    'algemeen' => $vehicleInfo['condition'],
    'accu' => $vehicleInfo['condition_battery'],
    'opmerkingen' => implode(PHP_EOL, [$vehicleInfo['condition_comments'], $vehicleInfo['consumer_comments']]),
];
