<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\DataObjects;

use Dealerdirect\Agreements\Tests\TestCase;
use Dealerdirect\Agreements\Tests\Traits\DataObjectFixtures;
use DealerDirect\Generic\Category\DistanceUnit;

/**
 * @covers \Dealerdirect\Agreements\DataObjects\Vehicle
 * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
 * @uses \Dealerdirect\Agreements\DataObjects\Conditions
 */
final class VehicleTest extends TestCase
{
    use DataObjectFixtures;

    public function test_method_get_odometer_reading_with_unit(): void
    {
        $vehicle = $this->fixtureVehicle();

        $this->assertSame('130.000 km', $vehicle->getOdometerReading());
    }

    public function test_method_get_odometer_reading_without_unit(): void
    {
        $vehicle = $this->fixtureVehicle();

        $this->assertSame('130.000', $vehicle->getOdometerReading(false));
    }

    public function test_method_get_odometer_reading_with_miles(): void
    {
        $vehicle = $this->fixtureVehicle(odoMeterReadingUnit: DistanceUnit::MILES);

        $this->assertSame('130.000 mi', $vehicle->getOdometerReading());
    }

    public function test_method_get_odometer_reading_with_null(): void
    {
        $vehicle = $this->fixtureVehicle(odoMeterReading: null);

        $this->assertSame('-', $vehicle->getOdometerReading());
    }
}
