<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\Pdf\Templates;

use Dealerdirect\Agreements\Enums\Locale;
use Dealerdirect\Agreements\Pdf\Templates\MarktplaatsSalesAgreement;
use Dealerdirect\Agreements\Tests\TestCase;
use Dealerdirect\Agreements\Tests\Traits\DataObjectFixtures;

/**
 * @covers \Dealerdirect\Agreements\Pdf\Templates\MarktplaatsSalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\CarSalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\SalesAgreement
 * @covers \Dealerdirect\Agreements\Pdf\Templates\AbstractTemplate
 *
 * @uses \Dealerdirect\Agreements\DataObjects\Agent
 * @uses \Dealerdirect\Agreements\DataObjects\Conditions
 * @uses \Dealerdirect\Agreements\DataObjects\Contact
 * @uses \Dealerdirect\Agreements\DataObjects\SalesAgreement
 * @uses \Dealerdirect\Agreements\DataObjects\Vehicle
 */
final class MarktplaatsSalesAgreementTest extends TestCase
{
    use DataObjectFixtures;

    public function test_can_construct_with_all_locales(): void
    {
        $this->expectNotToPerformAssertions();

        /** @var \Dealerdirect\Agreements\Utils\Translator|\PHPUnit\Framework\MockObject\MockObject $translator */
        $translator = $this->createStub(\Dealerdirect\Agreements\Utils\Translator::class);
        $translator->method('get')->willReturn('translated string');

        new MarktplaatsSalesAgreement(Locale::NL_NL, $this->fixtureSalesAgreement(), $translator);
    }

    /**
     * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
     */
    public function test_render_returns_valid_html(): void
    {
        /** @var \Dealerdirect\Agreements\Utils\Translator|\PHPUnit\Framework\MockObject\MockObject $translator */
        $translator = $this->createStub(\Dealerdirect\Agreements\Utils\Translator::class);
        $translator->method('get')->willReturn('translated string');

        $template = new MarktplaatsSalesAgreement(Locale::NL_NL, $this->fixtureSalesAgreement(), $translator);

        $this->assertStringIsValidHtml($template->render(), 'Template should render valid HTML');
    }
}
