<?php

use Dealerdirect\Agreements\Utils;

$mediationContent = 'Deze overeenkomst werd opgemaakt na bemiddeling door: ';
if ($vehicleInfo['sales_agent'] === 0) {
    $mediationContent .= 'Marktplaats Auto Verkoopservice';
} else {
    $mediationContent .= $vehicleInfo['sales_agent_name'];
}

return [
    'sales_agreement_parties' => implode(
        PHP_EOL . PHP_EOL,
        [
            sprintf(
                '%s %s wonende te %s %s, %s, %s, %s, bereikbaar op %s hierna aangeduid als "verkoper"',
                strtoupper($vehicleInfo['consumer_first_letters']),
                mb_strtoupper($vehicleInfo['consumer_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['consumer_house_number']),
                strtoupper($vehicleInfo['consumer_zip_code_nl']),
                mb_strtoupper($vehicleInfo['consumer_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['consumer_country_name'], 'UTF-8'),
                $vehicleInfo['consumer_phone']
            ),
            sprintf(
                'En %s, gevestigd te %s %s, %s, %s, %s, bereikbaar op %s, hierna aangeduid als "koper" komen overeen',
                mb_strtoupper($vehicleInfo['company_name'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_street_name'], 'UTF-8'),
                strtoupper($vehicleInfo['company_house_number']),
                strtoupper($vehicleInfo['company_zip_code']),
                mb_strtoupper($vehicleInfo['company_city'], 'UTF-8'),
                mb_strtoupper($vehicleInfo['company_country_name'], 'UTF-8'),
                $vehicleInfo['company_phone']
            )
        ]
    ),
    'sales_agreement_status' => 'Het voertuig in de staat verkeert zoals door verkoper aangegeven en vermeld '
        . 'in de bijgevoegde voertuigomschrijving;',
    'sales_agreement_ownership' => sprintf(
        'Verkoper eigenaar is van de vermelde %s %s en gerechtigd is deze te verkopen. Verkoper dit voertuig '
            . 'wenst te verkopen aan koper en koper dit voertuig wenst te kopen.',
        strtoupper($vehicleInfo['make']),
        strtoupper($vehicleInfo['model'])
    ),
    'sales_agreement_description' => sprintf(
        'Het voertuig betreft een %s %s uit %s met een tellerstand van %s en het volgende kenteken: %s.',
        strtoupper($vehicleInfo['make']),
        strtoupper($vehicleInfo['model']),
        strtoupper($vehicleInfo['construction_year']),
        number_format($vehicleInfo['mileage'], 0, ',', '.'),
        strtoupper($vehicleInfo['license_plate'])
    ),
    'sales_agreement_payment' => sprintf(
        'Koper betaalt aan de verkoper een bedrag van € %s (Verkoopbedrag) voor de koop van het voertuig '
            . 'zoals in de omschrijving staat beschreven. Dit bedrag wordt in gezamenlijk overleg in contanten '
            . 'of per bankoverschrijving voldaan aan verkoper.',
        $vehicleInfo['consumer_sale_price']
    ),
    'sales_agreement_delivery' => sprintf(
        'Zoals overeengekomen %s. De overdracht dient binnen 14 dagen volbracht te zijn. ',
        $vehicleInfo['pick_up'] == '1'
            ? 'haalt de koper het voertuig op het door de verkoper aangegeven adres af'
            : 'brengt de verkoper het voertuig naar het adres waar de koper gevestigd is'
    ),
    'sales_agreement_mediation' => $mediationContent,
    'brandmodel' => sprintf('%s %s', $vehicleInfo['make'], $vehicleInfo['model']),
    'transmission' => $vehicleInfo['transmission'],
    'condition_profile' => $vehicleInfo['condition_tyre_profile'],
    'buildyear' => sprintf(
        '%s / %s',
        $vehicleInfo['construction_year'],
        Utils::formatDateOrDefault($vehicleInfo['first_ascription'])
    ),
    'examination' => Utils::formatDateOrDefault($vehicleInfo['examination']),
    'bodywork' => $vehicleInfo['bodywork'],
    'coating' => $vehicleInfo['upholstery'],
    'condition_inside' => $vehicleInfo['condition_interior'],
    'condition_outside' => $vehicleInfo['condition_bodywork'],
    'condition_driveable' => $vehicleInfo['condition_drivable'],
    'version' => $vehicleInfo['execution'],
    'power' => sprintf('%s cc / %s kW', $vehicleInfo['engine_capacity'], $vehicleInfo['power']),
    'miles' => number_format($vehicleInfo['mileage'], 0, ',', '.'),
    'colour' => sprintf('%s / %s', ucfirst($vehicleInfo['color']), $vehicleInfo['paint_type']),
    'condition_damagefree' => $vehicleInfo['condition_damage_free'],
    'fuel' => $vehicleInfo['fuel'],
    'vat' => $vehicleInfo['marge'],
    'condition_technical' => $vehicleInfo['condition_technical'],
    'comments' => $vehicleInfo['condition_comments'],
    'equipment1' => $vehicleInfo['options'][0],
    'equipment2' => $vehicleInfo['options'][1],
];
