<?php

namespace Dealerdirect\Agreements\Interfaces;

use Doctrine\DBAL\Driver\Connection;

interface Model
{
    /**
     * Model constructor
     *
     * @param Connection $dbal
     * @param int        $deliverId
     */
    public function __construct(Connection $dbal, int $deliverId);

    /**
     * Gets the deliverId
     *
     * @return integer
     */
    public function getDeliverId(): int;

    /**
     * Gets the locale
     *
     * @return string
     */
    public function getLocale(): string;

    /**
     * Gets the vehicleType
     *
     * @return string
     */
    public function getVehicleType(): string;

    /**
     * Function to get data for the agreement
     *
     * @return array
     */
    public function getPurchaseData(): array;

    /**
     * Function to get data for the agreement
     *
     * @return array
     */
    public function getSaleData(): array;

    /**
     * Function to log current action.
     *
     * @param string $action
     * @param string|int $user
     * @param string|null $ipAddress
     * @return void
     */
    public function log(string $action, $user = 0, $ipAddress = null): void;
}
