<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

use Dealerdirect\Agreements\Enums\DealerdirectLanguage;

final class PurchaseAgreementNotStoredException extends \Exception
{
    public function __construct(
        int $lotId,
        int $companyId,
        int $siteReference,
        DealerdirectLanguage $language,
        string $storageName,
    ) {
        parent::__construct(sprintf(
            'The agreement for lot %d, company %d, site reference %d and language %s was not stored with name %s',
            $lotId,
            $companyId,
            $siteReference,
            $language->value,
            $storageName
        ));
    }
}
