<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Exceptions;

final class InvalidTranslationTypeException extends \InvalidArgumentException
{
    public function __construct(string $translationType, array $validTranslationTypes)
    {
        parent::__construct(sprintf(
            'Invalid translation type "%s", valid types are: [%s]',
            $translationType,
            implode(', ', $validTranslationTypes)
        ));
    }
}
