<?php

use Dealerdirect\Agreements\Factory;

/**
 * @function getStorage
 * @function getEmailClient
 * @function getConnection
 *
 * @var int  $reference
 * @var int  $deliverId
 * @var bool $showFile
 */
require_once __DIR__ . '/bootstrap.php';

$purchaseAgreementFactory = Factory::forPurchaseAgreement(
    getStorage('/tmp/purchase-agreements'),
    Factory::getModelByReference($reference, getConnection(), $deliverId),
    getCloudinary(),
);

$purchaseAgreementFactory->delete();
$purchaseAgreementFactory->create();

if (!$showFile) {
    $purchaseAgreementFactory->send(getEmailClient(), ['dealerdirect' => $dealerdirectUrl]);

    echo 'Purchase Agreement is created and send' . PHP_EOL;
    exit;
}

header('Content-Type: application/pdf');
echo $purchaseAgreementFactory->show();
