<?php

use Dealerdirect\Agreements\Utils\GeneralUtils;

/**
 * @var Dealerdirect\Agreements\Pdf\Templates\PurchaseAgreement $this
 */
?>

<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?=$this->translate('labels.purchase_agreement')?></title>
    <style><?=file_get_contents(__DIR__ . '/css/purchase-agreement.css')?></style>
</head>

<body>
    <main>
        <h1><b><?=$this->data->vehicle->brand?> <?=$this->data->vehicle->model?></b></h1>
        <?php if (Dealerdirect\Generic\Category\Site::REF_CAR_MARKTPLAATS_NL === $this->data->siteReference) : ?>
            <h3 style="border: none;"?><?= $this->translate('labels.platform') ?>: Marktplaats</h3>
        <?php endif; ?>

        <table width="100%">
            <tr>
                <td colspan="2">
                    <h3><?= $this->translate('labels.contact') ?></h3>
                </td>
            </tr>
            <tr>
                <td width="60%" valign="top" style="text-align: left;">
                    <table width="100%">
                        <?php foreach ($this->getContactDetails() as $label => $value) : ?>
                            <tr>
                                <td class="label" width="50%"><?= $label ?></td>
                                <td width="50%"><?= $value ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </td>
                <td width="30%" valign="top" style="text-align: right;">
                    <div class="image-wrap" style="text-align: center;">
                        <img style="text-align:center;" src="<?=$this->getImage()?>" class="img-responsive" />
                    </div>
                </td>
            </tr>
        </table>
        <table width="100%">
            <tr>
                <td width="60%" valign="top" style="text-align:left;">
                    <table width="100%">
                        <tr>
                            <td colspan="2">
                                <h3><?= $this->translate('labels.vehicle_information') ?></h3>
                            </td>
                        </tr>
                        <?php foreach ($this->getVehicleData() as $label => $value) : ?>
                            <tr>
                                <td class="label" width="50%"><?= $label ?></td>
                                <td width="50%"><?= $value ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </td>
                <?php if (!empty($accessories = $this->getVehicleAccessories())) : ?>
                    <td width="30%" align="right" valign="top">
                        <table width="100%">
                            <tr>
                                <td width="100%"><h3><?= $this->translate('labels.options') ?></h3></td>
                            </tr>
                            <tr>
                                <td><?= $accessories ?></td>
                            </tr>
                        </table>
                    </td>
                <?php endif; ?>
            </tr>
        </table>

        <table width="100%" style="page-break-after: always;">
            <tr>
                <td width="60%" align="left" valign="top">
                    <table width="100%">
                        <tr>
                            <td colspan="2">
                                <h3><?= $this->translate('labels.conditions') ?></h3>
                            </td>
                        </tr>
                        <?php $conditions = $this->data->vehicle->conditions->for(
                            $this->translator,
                            \Dealerdirect\Generic\Enums\SiteReference::from(
                                $this->data->siteReference
                            )->toVehicleType()
                        ); ?>

                        <?php foreach ($conditions as $label => $value) : ?>
                            <tr>
                                <td class="label" width="50%"><?= $label ?></td>
                                <td width="50%"><?= $value ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </td>

                <td width="30%" align="right" valign="top">
                    <table width="100%">
                        <tr>
                            <td>
                                <h3><?= $this->translate('labels.price') ?></h3>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="price-wrap">
                                    <p>
                                        <?=$this->translate('purchase_agreement.price', [
                                            'price' => GeneralUtils::formatNumber($this->data->getPrice())
                                        ])?>
                                    </p>
                                </div>
                                <tr>
                                    <td class="label">
                                        <?= $this->translate('labels.delivery') ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <?= $this->translate("purchase_agreement.pick_up.{$this->data->pickUp}") ?>
                                    </td>
                                </tr>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

        <?php if (!empty($checklist = $this->getChecklist())) : ?>
            <table width="100%" >
                <tr>
                    <td colspan="2">
                        <h3>Checklist</h3>
                    </td>
                </tr>
                <tr>
                    <?php foreach ($checklist as $partition) : ?>
                        <td width="50%" valign="top">
                            <table width="100%">
                                <?php foreach ($partition as $checklistItem) : ?>
                                    <?php if (empty($checklistItem['answer']) || '-' === $checklistItem['answer']) : ?>
                                        <!-- Skip empty checklist items -->
                                        <?php continue; ?>
                                    <?php endif; ?>

                                    <tr>
                                        <td class="label" width="50%"><?= $checklistItem['question'] ?></td>
                                    </tr>
                                    <tr>
                                        <td width="100%"><?= $checklistItem['answer'] ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        </td>
                    <?php endforeach; ?>
                </tr>
            </table>
        <?php endif; ?>
        <?php foreach ($this->getComments() as $label => $comment) : ?>
            <div style="page-break-inside: avoid;">
                <h3 style="border-bottom: none;"><?=$label?></h3>
                <div class="comment">
                    <p><?=$comment?></p>
                </div>
            </div>
        <?php endforeach; ?>
    </main>
    <footer>
        <table width="100%" class="footer-table">
            <tr>
                <td valign="middle" class="footer-text">
                    <b><?= $this->translate('labels.date') ?></b> <?= (new \DateTime())->format('d-m-Y') ?>
                    &nbsp;
                    <b><?= $this->translate('labels.lot') ?></b> <?= $this->data->lotId ?>
                </td>
                <td class="logo-wrap">
                    <img class="logo" align="right" src="<?= $this->getLogo() ?>" />
                </td>
            </tr>
        </table>
    </footer>
</body>
</html>
