<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Enums;

use Dealerdirect\Agreements\Exceptions\InvalidSiteReferenceException;
use Dealerdirect\Generic\Category\Site;

enum Locale: string
{
    case NL_NL = 'nl_NL';
    case NL_BE = 'nl_BE';
    case FR_BE = 'fr_BE';
    case DE_DE = 'de_DE';
    case EN = 'en';

    public function toDealerdirectLanguage(): DealerdirectLanguage
    {
        return match ($this) {
            self::NL_NL => DealerdirectLanguage::NL,
            self::NL_BE => DealerdirectLanguage::NL_BE,
            self::FR_BE => DealerdirectLanguage::FR,
            self::DE_DE => DealerdirectLanguage::DE,
        };
    }

    public static function fromSiteReference(int $siteReference): self
    {
        return match ($siteReference) {
            Site::REF_BICYCLE_NL,
            Site::REF_CAR_NL,
            Site::REF_CAR_MARKTPLAATS_NL,
            Site::REF_MOTO_NL,
            Site::REF_SCOOTER_NL => self::NL_NL,

            Site::REF_CAR_BE_NL,
            Site::REF_MOTO_BE => self::NL_BE,

            Site::REF_CAR_DE,
            Site::REF_MOTO_DE => self::DE_DE,

            default => throw new InvalidSiteReferenceException($siteReference),
        };
    }
}
