<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Factories;

use Dealerdirect\Sdk\Facade\Email;

interface Factory
{
    public function create(): void;

    public function show(): string;

    public function delete(): void;

    public function exists(): bool;

    public function store(string $pdfContent): void;

    /**
     * @param array<string,string> $domains
     */
    public function send(Email $emailClient, ?array $domains = null, ?string $encryptionKey = null): void;

    public function getStorageName(): string;
}
