<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Tests\Models;

use Dealerdirect\Agreements\Models\AbstractModel;
use Dealerdirect\Agreements\Models\MotorbikeModel;
use Dealerdirect\Agreements\Tests\TestCase;
use Dealerdirect\Generic\Category\Site;
use Doctrine\DBAL\Connection;

/**
 * @covers \Dealerdirect\Agreements\Models\MotorbikeModel
 * @covers \Dealerdirect\Agreements\Models\AbstractModel
 *
 * @uses \Dealerdirect\Agreements\DataObjects\Contact
 * @uses \Dealerdirect\Agreements\Enums\Locale
 * @uses \Dealerdirect\Agreements\Utils\CommentsFormatter
 * @uses \Dealerdirect\Agreements\Utils\GeneralUtils
 * @uses \Dealerdirect\Agreements\DataObjects\PurchaseAgreement
 * @uses \Dealerdirect\Agreements\DataObjects\SalesAgreement
 * @uses \Dealerdirect\Agreements\DataObjects\Vehicle
 */
final class MotorbikeModelTest extends TestCase
{
    use TestCases;

    public function getModel(Connection $connection, ?int $deliverId = 1): AbstractModel
    {
        return new MotorbikeModel($connection, $deliverId);
    }

    public function getTable(): string
    {
        return 'dealer01_ddmoto.BO_Verkopen_NL';
    }

    public function getLogTable(): string
    {
        return 'dealer01_ddmoto.BO_Verkopen_NL_loggg';
    }

    /**
     * @return array<string,int|string|null>
     */
    public function fixtureFetchSaleData(?int $checklistId = null, ?\DateTime $inspectionValidUntil = null): array
    {
        return [
            'lot_id' => 1,
            'site_reference' => Site::REF_MOTO_NL,
            'license_plate' => 'license_plate',
            'inspection_valid_until' => $inspectionValidUntil ? $inspectionValidUntil->format('Y-m-d') : null,
            'make' => 'make',
            'model' => 'model',
            'execution' => 'execution',
            'fuel' => null,
            'first_ascription' => null,
            'construction_year' => 2021,
            'color' => null,
            'color_2' => null,
            'color_3' => null,
            'power' => null,
            'mileage' => 1,
            'mileage_type' => 1,
            'transmission' => null,
            'maintenance_history' => null,
            'marge' => null,
            'condition_exterior' => null,
            'condition_technical' => null,
            'condition_front_tire' => null,
            'condition_rear_tire' => null,
            'condition_propulsion' => null,
            'damage_free' => null,
            'internal_comments' => 'internal_comments',
            'consumer_comments' => 'consumer_comments',
            'bodywork' => 0,
            'consumer_salutation' => 0,
            'consumer_name' => 'consumer_name',
            'consumer_first_letters' => 'consumer_first_letters',
            'consumer_street_name' => 'consumer_street_name',
            'consumer_house_number' => 'consumer_house_number',
            'consumer_zip_code' => 'consumer_zip_code',
            'consumer_city' => 'consumer_city',
            'consumer_country' => 1,
            'consumer_phone' => 'consumer_phone',
            'consumer_mobile' => 'consumer_mobile',
            'consumer_email' => 'consumer_email',
            'company_name' => 'company_name',
            'company_street_name' => 'company_street_name',
            'company_house_number' => 'company_house_number',
            'company_zip_code' => 'company_zip_code',
            'company_country' => 1,
            'company_city' => 'company_city',
            'company_phone' => 'company_phone',
            'company_agree_email' => 'company_agree_email',
            'company_agree_email_2' => 'company_agree_email_2',
            'sales_date' => '2021-01-01',
            'sales_price' => 1,
            'sales_fee' => 1,
            'sales_agent' => 1,
            'company_id' => 1,
            'sales_agent_name' => 'sales_agent_name',
            'ip_address' => 'ip_address',
            'pick_up' => 1,
            'vehicle_options' => '1;2;3',
            'bicycle_type' => 1,
            'gears' => 0,
            'engine_position' => 2,
            'battery_wattage' => 1,
            'condition_battery' => 1,
            'condition_general' => 1,
            'checklist_id' => $checklistId,
        ];
    }
}
