<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Pdf\Templates;

final class BicycleSalesAgreement extends MotorbikeSalesAgreement
{
    public function getVehicleValues(): array
    {
        return array_filter([
            [
                'label' => $this->translate('labels.make_model'),
                'value' => "{$this->data->vehicle->brand} {$this->data->vehicle->model}",
            ],
            [
                'label' => $this->translate('labels.type'),
                'value' => $this->data->vehicle->bicycleType
                    ? $this->translate("bicycle.bicycle_type.{$this->data->vehicle->bicycleType}")
                    : '-',
            ],
            [
                'label' => $this->translate('labels.construction_year'),
                'value' => $this->data->vehicle->constructionYear,
            ],
            [
                'label' => $this->translate('labels.engine_position'),
                'value' => $this->data->vehicle->enginePosition
                    ? $this->translate("bicycle.engine_position.{$this->data->vehicle->enginePosition}")
                    : '-',
            ],
            [
                'label' => $this->translate('labels.battery_wattage'),
                'value' => $this->data->vehicle->batteryWattage
                    ? $this->translate("bicycle.battery_wattage.{$this->data->vehicle->batteryWattage}")
                    : '-',
            ],
            [
                'label' => $this->translate('labels.amount_of_gears'),
                'value' => $this->data->vehicle->amountOfGears
                    ? $this->translate("bicycle.gears.{$this->data->vehicle->amountOfGears}")
                    : '-',
            ],
            [
                'label' => $this->translate('labels.odometer_reading'),
                'value' => $this->data->vehicle->getOdometerReading(),
            ],
            [
                'label' => $this->translate('labels.color'),
                'value' => $this->translate("general.color.{$this->data->vehicle->colors[0]}"),
            ],
        ]);
    }

    public function getConditions(): array
    {
        return [
            [
                'label' => $this->translate('labels.general'),
                'value' => $this->translate("vehicle.condition.{$this->data->conditions->general}"),
            ],
            [
                'label' => $this->translate('labels.battery'),
                'value' => $this->translate("vehicle.condition.{$this->data->conditions->battery}"),
            ],
        ];
    }
}
