<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\Pdf\Templates;

use Dealerdirect\Agreements\Utils\GeneralUtils;

class MarktplaatsSalesAgreement extends CarSalesAgreement
{
    public function getTemplate(): string
    {
        return 'marktplaats-sales-agreement.php';
    }

    public function getAgreements(): array
    {
        return [
            'title' => $this->translate('labels.considering_that'),
            'parts' => [
                [
                    'title' => $this->translate('labels.ownership'),
                    'content' => $this->translate('sales_agreement.agreements.ownership', [
                        'brand' => $this->data->vehicle->brand,
                        'model' => $this->data->vehicle->model,
                    ]),
                ],
                [
                    'title' => $this->translate('labels.state'),
                    'content' => $this->translate('sales_agreement.agreements.status'),
                ],
                [
                    'title' => $this->translate('labels.vehicle'),
                    'content' => $this->translate('sales_agreement.agreements.description', [
                        'brand' => $this->data->vehicle->brand,
                        'model' => $this->data->vehicle->model,
                        'construction_year' => $this->data->vehicle->constructionYear,
                        'odometer_reading' => $this->data->vehicle->getOdometerReading(false),
                        'license_plate' => $this->data->vehicle->licensePlate,
                    ]),
                ],
                [
                    'title' => $this->translate('labels.payment'),
                    'content' => $this->translate('sales_agreement.agreements.payment', [
                        'sale_price' => number_format(GeneralUtils::getConsumerPrice(
                            $this->data->salesPrice,
                            $this->data->salesFee
                        ), 0, ',', '.'),
                    ]),
                ],
                [
                    'title' => $this->translate('labels.delivery'),
                    'content' => $this->data->pickUp
                        ? $this->translate('sales_agreement.agreements.delivery_pickup')
                        : $this->translate('sales_agreement.agreements.delivery_deliver'),
                ],
                [
                    'title' => $this->translate('labels.mediation'),
                    'content' => $this->translate('sales_agreement.agreements.mediation', [
                        'agent_name' => 0 !== $this->data->salesAgent->id ? $this->data->salesAgent->name : '',
                    ]),
                    //  nl2br($this->data->sales_agreement_mediation),
                ],
            ],
        ];
    }
}
