<?php

declare(strict_types=1);

namespace Dealerdirect\Agreements\DataObjects;

use Dealerdirect\Agreements\Enums\Locale;

/**
 * @codeCoverageIgnore
 */
final class SalesAgreement implements DataObject
{
    /**
     * @param array<int,array<string,mixed>>|null $checklist
     */
    public function __construct(
        public readonly Locale $locale,
        public readonly string $vehicleType,
        public readonly int $lotId,
        public readonly int $deliverId,
        public readonly int $siteReference,
        public readonly Contact $consumer,
        public readonly Vehicle $vehicle,
        public readonly Conditions $conditions,
        public readonly Contact $company,
        public readonly Agent $salesAgent,
        public readonly ?array $checklist,
        public readonly string $internalComments,
        public readonly string $consumerComments,
        public readonly bool $pickUp,
        public readonly \DateTime $soldDate,
        public readonly int $salesPrice,
        public readonly int $salesFee,
    ) {
    }
}
