<?php

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once dirname(__DIR__) . '/vendor/autoload.php';

use Doctrine\DBAL\DriverManager;
use Dealerdirect\Agreements\Models\CarBeModel;
use Dealerdirect\Agreements\Models\CarNlModel;
use DealerDirect\Generic\Category\VehicleType;
use Dealerdirect\Agreements\Models\MotorbikeModel;
use Dealerdirect\Agreements\Agreements\PurchaseAgreement;

$vehicleType = $_GET['vehicle_type'] ?? VehicleType::CAR;
VehicleType::assertExists($vehicleType);

$country = $_GET['country'] ?? 'nl';
$project = "{$vehicleType}_{$country}";
$deliverId = (int) $_GET['deliver_id'] ?? false;
$dbName = in_array($vehicleType, [VehicleType::MOTOR, VehicleType::SCOOTER])
    ? 'dealer01_ddmoto'
    : 'dealer01_ddmain';

if (!$deliverId) {
    throw new Exception('Error, could not fetch data without "deliver_id". Add it to the GET params');
}

$dbal = DriverManager::getConnection(
    [
        'dbname' => $dbName,
        'user' => 'vagrant',
        'password' => 'vagrant',
        'host' => 'aio.test',
        'driver' => 'pdo_mysql',
    ],
    new \Doctrine\DBAL\Configuration()
);

switch ($project) {
    case 'car_nl':
        $model = new CarNlModel($dbal, $deliverId);
        break;
    case 'car_be':
        $model = new CarBeModel($dbal, $deliverId);
        break;
    case 'motorbike_nl':
    case 'motorbike_be':
    case 'motorbike_de':
        $model = new MotorbikeModel($dbal, $deliverId);
        break;
    default:
        throw new Exception("Error, project '$project' is not defined!");
}

$agreement = new PurchaseAgreement(
    $model,
    'https://email-service.email-service.test/api/v1',
    'R72SaMOwBou595zLuW1HtPHkYZd6og1T',
    'https://dealerdirect.eu.aio.test'
);

if ($agreement->create() === false) {
    $model->log('Could not create Purchase Agreement');
    echo 'Could not create Purchase Agreement';
    exit;
}
if ($agreement->send() === false) {
    $model->log('Could not send Purchase Agreement');
    echo 'Could not send Purchase Agreement';
    exit;
}
$model->log('Purchase Agreement is created and send');
echo 'Purchase Agreement is created and send';
