<?php

namespace Dealerdirect\Authorization;

use Dealerdirect\Authorization\Repository;
use DealerDirect\Generic\Category\Site;
use Exception;

class Dealer
{
    private const DEFAULT_ALLOWED_REFERENCES = [
        Site::REF_CAR_NL,
        Site::REF_CAR_BE_NL,
        Site::REF_MOTO_NL,
        Site::REF_MOTO_BE,
        Site::REF_MOTO_DE,
        Site::REF_SCOOTER_NL,
        Site::REF_BICYCLE_NL,
    ];

    private Repository $repository;

    private int $dealerId;

    private array $allowedReferences = [];

    /**
     * @param Repository $repository
     * @param integer $dealerId
     */
    public function __construct(Repository $repository, int $dealerId)
    {
        $this->repository = $repository;
        $this->dealerId = $dealerId;
    }

    /**
     * @return bool
     * @throws Exception
     */
    public function accessAllowedForReference(int $reference): bool
    {
        return in_array($reference, $this->getAllowedReferences(), true);
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getAllowedReferences(): array
    {
        if ($this->dealerId === 0) {
            return self::DEFAULT_ALLOWED_REFERENCES;
        }

        if (empty($this->allowedReferences)) {
            $this->allowedReferences = $this->repository->getAllowedReferences($this->dealerId);
        }

        return $this->allowedReferences;
    }
}
