<?php

use Dealerdirect\Authorization;
use DealerDirect\Generic\Category\Site;
use DealerDirect\Generic\Category\VehicleType;
use Doctrine\DBAL\DriverManager;

require_once dirname(__DIR__) . '/vendor/autoload.php';

$dealerId = 9999;
$vehicleType = VehicleType::CAR;
$reference = Site::REF_CAR_MARKTPLAATS_NL;

$connection = DriverManager::getConnection([
    'dbname' => 'dealer01_ddmain',
    'user' => 'vagrant',
    'password' => 'vagrant',
    'host' => 'aio.test',
    'driver' => 'pdo_mysql',
    'charset'  => 'utf8mb4',
], new \Doctrine\DBAL\Configuration());

$repository = new Authorization\Repository($connection);
$dealer = new Authorization\Dealer($repository, $dealerId);

// getAllowedReferences
try {
    var_dump([
        'getAllowedReferences' => $dealer->getAllowedReferences(),
    ]);
} catch (Exception $exception) {
    echo "Error 'getAllowedReferences': {$exception->getMessage()}" . PHP_EOL;
}

// accessAllowedForReference
try {
    var_dump([
        'accessAllowedForReference' => $dealer->accessAllowedForReference($reference),
    ]);
} catch (Exception $exception) {
    echo "Error 'accessAllowedForReference': {$exception->getMessage()}" . PHP_EOL;
}
