<?php

namespace Dealerdirect\Authorization;

use Dealerdirect\Authorization\Repository;
use Exception;

class Dealer
{
    private Repository $repository;

    private int $dealerId;

    private array $allowedReferences = [];

    /**
     * @param Repository $repository
     * @param integer $dealerId
     */
    public function __construct(Repository $repository, int $dealerId)
    {
        $this->repository = $repository;
        $this->dealerId = $dealerId;
    }

    /**
     * @return bool
     * @throws Exception
     */
    public function accessAllowedForReference(int $reference): bool
    {
        return in_array($reference, $this->getAllowedReferences(), true);
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getAllowedReferences(): array
    {
        if (empty($this->allowedReferences)) {
            $this->allowedReferences = $this->repository->getAllowedReferences($this->dealerId);
        }

        return $this->allowedReferences;
    }
}
