<?php

namespace Dealerdirect\Authorization;

use Doctrine\DBAL\Connection;
use Exception;

class Repository
{
    private Connection $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    public function getAllowedReferences(int $dealerId): array
    {
        $allowed = $this->connection->fetchOne(
            <<<SQL
            SELECT access_allowed
            FROM dealer01_ddmain.dealerdirect_bedr
            WHERE bedrijvenID = :dealerId
            SQL,
            compact('dealerId')
        );

        if ($allowed === false) {
            throw new Exception("Error, dealer not found with id '$dealerId'");
        }

        return array_map('intval', json_decode($allowed, true) ?: []);
    }
}
