<?php

namespace Dealerdirect\Deliveries\Repositories;

use DateTime;

abstract class MotorRepository extends AbstractRepository
{
    protected $table = 'dealer01_ddmoto.BO_Verkopen_NL';
    protected $lotsTable = 'dealer01_ddmoto.BO_Motorfiets';

    /**
     * @inheritDoc
     */
    public function updateStatusToSold(int $lotId): bool
    {
        return $this->connection->update(
            'dealer01_ddmoto.BO_Motorfiets',
            ['status' => 2],
            ['id' => $lotId]
        ) === 1;
    }

    /**
     * @inheritDoc
     */
    public function updateLockedSale(int $lotId): bool
    {
        $lockId = $this->connection->fetchOne(
            <<<SQL
            SELECT id FROM dealer01_ddmoto.BO_Verkopen_Geopend
            WHERE lot_id = :lotId
            ORDER BY id DESC
            SQL,
            compact('lotId')
        );

        if (empty($lockId)) {
            return true;
        }

        return $this->connection->update(
            'dealer01_ddmoto.BO_Verkopen_Geopend',
            ['sold' => 1],
            ['id' => $lockId]
        ) === 1;
    }

    /**
     * @inheritDoc
     */
    public function setContactDate(int $deliverId, int $countryId, DateTime $dateTime): bool
    {
        return $this->connection->insert(
            'dealer01_ddmoto.BO_Contact_Date',
            [
                'sale_id' => $deliverId,
                'country_id' => (int) $countryId,
                'date_contact' => $dateTime->format('Y-m-d'),
            ]
        ) === 1;
    }

    /**
     * @inheritDoc
     */
    public function getSaleData(int $bidId): array
    {
        return $this->fetch(
            <<<SQL
            SELECT
                BOM.id lotId,
                BOM.id kavelref,
                BOM.reference,
                PER.aanhef aan_aanhef_kl,
                CONCAT_WS(' ', PER.voornaam, PER.achternaam) aan_naam_kl,
                PER.straatnaam aan_straat_kl,
                PER.huisnummer aan_huisnummer_kl,
                PER.postcode aan_postcode_kl,
                PER.woonplaats aan_woonplaats_kl,
                PER.country_id aan_land_kl,
                PER.country_id,
                PER.telefoon1 aan_tel_kl,
                PER.telefoon2 aan_gsm_kl,
                PER.provincie aan_provincie_kl,
                PER.email aan_email_kl,
                BB.id bid_id,
                BB.bedrijvenID,
                BB.bedrag verkoop_bedrag,
                BB.gehaald,
                BB.com bem_bedrag,
                ddb.pakket,
                ddb.bonus_profile,
                me.merkNaam make,
                mo.modelNaam model
            FROM dealer01_ddmoto.BO_Biedhistorie BB
                INNER JOIN dealer01_ddmoto.BO_Motorfiets BOM
                    ON BOM.id = BB.voertuigID
                INNER JOIN dealer01_ddmoto.BO_Persoon AS PER
                    ON BOM.persoonID = PER.persoonID
                INNER JOIN dealer01_ddmain.dealerdirect_bedr ddb
                    ON ddb.bedrijvenID = BB.bedrijvenID
                LEFT JOIN dealer01_webservices.SB_MERKEN me
                    ON me.merkID = BOM.merk
                LEFT JOIN dealer01_webservices.SB_MODELLEN mo
                    ON mo.modelID = BOM.model
                    AND mo.merkID = BOM.merk
            WHERE BB.id = :bidId
                AND BOM.status != 2
            SQL,
            compact('bidId')
        ) ?: [];
    }

    /**
     * @inheritDoc
     */
    public function getSmsData(int $deliverId): array
    {
        return $this->fetch(
            <<<SQL
            SELECT
                pers.telefoon1 phone1,
                pers.telefoon2 phone2,
                pers.email,
                makes.merkNaam make,
                models.modelNaam model
            FROM {$this->table} delivery
                INNER JOIN dealer01_ddmoto.BO_Motorfiets lot
                    ON lot.id = delivery.kavelref
                INNER JOIN dealer01_ddmoto.BO_Persoon pers
                    ON pers.PersoonID = lot.PersoonID
                LEFT JOIN dealer01_webservices.SB_MERKEN makes
                    ON makes.merkID = lot.automerk
                LEFT JOIN dealer01_webservices.SB_MODELLEN models
                    ON models.modelID = lot.autotype
            WHERE delivery.id = :deliverId
            SQL,
            compact('deliverId')
        ) ?: [];
    }
}
