<?php

namespace Dealerdirect\Deliveries\Exceptions;

class AddSaleException extends DeliveryException
{
    public static function invalidData(array $missingKeys)
    {
        $missingKeys = implode(', ', $missingKeys);

        return new static("Invalid data: [$missingKeys]");
    }

    /**
     * Exception for update locked sales.
     *
     * @param integer $lotId
     * @return AddSaleException
     */
    public static function updateLockedSale($lotId)
    {
        return new static("Could not update locked sale with [lotId: $lotId]");
    }

    /**
     * Exception for update lot status.
     *
     * @param integer $lotId
     * @return AddSaleException
     */
    public static function updateLotStatus($lotId)
    {
        return new static("Lot status not updated to sold with [lotId: $lotId].");
    }
}
