<?php

namespace Dealerdirect\Deliveries\Exceptions;

use DateTime;

class DeliveryException extends \Exception
{
    /**
     * @param array $array
     * @return string
     */
    protected static function arrayToString(array $array)
    {
        return implode(', ', array_map(
            function ($value, $key) {
                return sprintf("%s: %s", $key, $value instanceof DateTime ? $value->format('d-m-Y') : $value);
            },
            $array,
            array_keys($array)
        ));
    }

    /**
     * @param string $branch
     * @return DeliveryException
     */
    public static function invalidBranch($branch)
    {
        return new static("Invalid branch '$branch'.");
    }

    /**
     * @param mixed $key
     * @return DeliveryException
     */
    public static function config($key)
    {
        return new static("Missing required config key '$key'.");
    }

    /**
     * @param \Exception[] $exceptions
     * @return DeliveryException
     */
    public static function sendAgreements(array $exceptions)
    {
        $messages = implode("' AND '", array_map(function (\Exception $exception) {
            return $exception->getMessage();
        }, $exceptions));

        return new static("Could not send agreement(s); Error messages: '$messages'", 0, reset($exceptions));
    }
}
